import { Link, useLocation } from "wouter";
import { Plane } from "lucide-react";

export default function Header() {
  const [location] = useLocation();

  return (
    <header className="bg-[#1E40AF] text-white shadow-md">
      <div className="container mx-auto px-4 py-4 flex justify-between items-center">
        <div className="flex items-center">
          <Plane className="h-8 w-8 mr-2 text-[#3B82F6]" />
          <h1 className="text-xl font-bold" style={{ fontFamily: "Montserrat, sans-serif" }}>SkyLog</h1>
        </div>
        <nav>
          <ul className="flex space-x-6">
            <li>
              <Link href="/" className={`${location === "/" ? "text-[#3B82F6]" : "hover:text-[#3B82F6]"} transition-colors`}>
                Dashboard
              </Link>
            </li>
            <li>
              <Link href="/jumps" className={`${location === "/jumps" ? "text-[#3B82F6]" : "hover:text-[#3B82F6]"} transition-colors`}>
                Jumps
              </Link>
            </li>
            <li>
              <Link href="/add" className={`${location === "/add" ? "text-[#3B82F6]" : "hover:text-[#3B82F6]"} transition-colors`}>
                Add Jump
              </Link>
            </li>
          </ul>
        </nav>
      </div>
    </header>
  );
}
