import { pgTable, text, serial, integer, date } from "drizzle-orm/pg-core";
import { createInsertSchema } from "drizzle-zod";
import { z } from "zod";

export const jumps = pgTable("jumps", {
  id: serial("id").primaryKey(),
  jumpNumber: integer("jump_number").notNull(),
  jumpType: text("jump_type").notNull(),
  dropzone: text("dropzone").notNull(),
  altitude: text("altitude").notNull(),
  aircraft: text("aircraft").notNull(),
  equipment: text("equipment").notNull(),
  jumpDate: date("jump_date").notNull(),
  notes: text("notes"),
});

export const insertJumpSchema = createInsertSchema(jumps).omit({
  id: true,
});

export const jumpQuerySchema = z.object({
  search: z.string().optional(),
  dropzone: z.string().optional(),
  sort: z.string().optional(),
  page: z.string().transform(val => parseInt(val) || 1).optional(),
  limit: z.string().transform(val => parseInt(val) || 10).optional(),
});

export type InsertJump = z.infer<typeof insertJumpSchema>;
export type Jump = typeof jumps.$inferSelect;
export type JumpQuery = z.infer<typeof jumpQuerySchema>;
