import React from "react";
import { LucideIcon } from "lucide-react";

interface StatCardProps {
  title: string;
  value: string | number;
  icon: LucideIcon;
  iconColor: string;
  iconBgColor: string;
  additionalInfo?: React.ReactNode;
}

export default function StatCard({ 
  title, 
  value, 
  icon: Icon, 
  iconColor, 
  iconBgColor, 
  additionalInfo 
}: StatCardProps) {
  return (
    <div className="bg-white rounded-lg shadow p-6">
      <div className="flex items-start justify-between">
        <div>
          <p className="text-sm font-medium text-gray-600">{title}</p>
          <p className="text-3xl font-bold text-gray-800">{value}</p>
        </div>
        <div className={`p-2 ${iconBgColor} bg-opacity-10 rounded-md`}>
          <Icon className={`h-6 w-6 ${iconColor}`} />
        </div>
      </div>
      {additionalInfo && (
        <div className="mt-4">
          {additionalInfo}
        </div>
      )}
    </div>
  );
}
