import { useState } from "react";
import { Tabs, TabsList, TabTrigger, TabsContent } from "@/components/ui/tab";
import AddJumpForm from "@/components/AddJumpForm";
import CSVUpload from "@/components/CSVUpload";
import type { Jump } from "@shared/schema";
import { useLocation } from "wouter";

export default function AddJump() {
  const [, setLocation] = useLocation();
  const [editJump, setEditJump] = useState<Jump | undefined>(undefined);
  
  // If we have a jump to edit from the table, show the manual entry tab
  const defaultTab = editJump ? "manual" : "manual";

  return (
    <section className="mb-12">
      <h2 className="text-2xl font-bold text-gray-800 mb-6" style={{ fontFamily: "Montserrat, sans-serif" }}>
        {editJump ? "Edit Jump" : "Add New Jump"}
      </h2>
      
      <div className="bg-white rounded-lg shadow p-6">
        <Tabs defaultValue={defaultTab}>
          <TabsList>
            <TabTrigger value="manual">Manual Entry</TabTrigger>
            {!editJump && <TabTrigger value="csv">CSV Upload</TabTrigger>}
          </TabsList>
          
          <TabsContent value="manual">
            <AddJumpForm 
              editJump={editJump} 
              onSuccess={() => {
                if (editJump) {
                  setEditJump(undefined);
                  setLocation("/jumps");
                }
              }} 
            />
          </TabsContent>
          
          <TabsContent value="csv">
            <CSVUpload />
          </TabsContent>
        </Tabs>
      </div>
    </section>
  );
}
